
/***********************************************************************************************
SASS descriptive statistics table
***********************************************************************************************/

# delimit;
capture log close;
capture program drop all;
clear;
clear matrix;
set more off;
set mem 500M;
estimates clear;
set matsize 2000;
set maxvar 32000;
version 10;

cd "C:\Users\nschwart\Desktop\SASS\Final Data";

global files "assign_elmid lunch50ormore_assign_elmid";

foreach f of global files {;

use "t_`f'.dta", clear;

replace male = 100*male;
replace black_nh = 100*black_nh;
replace hispanic = 100*hispanic;
replace reg_cert = 100*reg_cert;
replace ma_dummy = 100*ma_dummy;
replace math_ELA_ratio_alt = 100*math_ELA_ratio_alt;
replace departmentalized = 100*departmentalized;
replace math_ratio_alt = 100*math_ratio_alt;
replace ELA_ratio_alt = 100*ELA_ratio_alt;
replace sci_ratio_alt = 100*sci_ratio_alt;
replace ss_ratio_alt = 100*ss_ratio_alt;

estpost sum male AGE_T black_nh hispanic school_enroll_hun pct_lunch pct_min 
departmentalized academic_time math_ratio_alt ELA_ratio_alt sci_ratio_alt ss_ratio_alt z_sch_disc z_stu_cult avg_class salary ma_dummy [w=TFNLWGT];
eststo, title(Teachers: `f');

};

foreach f of global files {;

use "p_`f'.dta", clear;

replace p_male = 100*p_male;
replace p_black_nh = 100*p_black_nh;
replace p_hispanic = 100*p_hispanic;
replace skills_or_excellence=100*skills_or_excellence;

estpost sum p_male p_age p_black_nh p_hispanic school_enroll_hun pct_lunch pct_min 
skills_or_excellence [w=AFNLWGT];
eststo, title(Principals: `f');

};

estout * using "Final Tables\SASS_descriptives.txt",
cells(mean (fmt(1)))stats(N, fmt(0)) replace;

estimates clear;

foreach f of global files {;

use "t_`f'.dta", clear;

replace male = 100*male;
replace black_nh = 100*black_nh;
replace hispanic = 100*hispanic;
replace reg_cert = 100*reg_cert;
replace ma_dummy = 100*ma_dummy;
replace math_ELA_ratio_alt = 100*math_ELA_ratio_alt;

estpost sum male AGE_T black_nh hispanic school_enroll_hun pct_lunch pct_min 
 hrs_per_wk academic_time math_ELA_time math_time ELA_time academ_time_ratio math_ELA_time_ratio math_ELA_ratio_alt math_time_ratio
  math_ratio_alt ELA_time_ratio ELA_ratio_alt departmentalized
  avg_class salary z_resource ba_dummy ma_dummy union_dummy reg_cert
  z_sch_disc z_stu_cult autonomy [w=TFNLWGT];
eststo, title(Teachers: `f');

};

foreach f of global files {;

use "p_`f'.dta", clear;

replace p_male = 100*p_male;
replace p_black_nh = 100*p_black_nh;
replace p_hispanic = 100*p_hispanic;
replace skills_or_excellence=100*skills_or_excellence;

estpost sum p_male p_age p_black_nh p_hispanic school_enroll_hun pct_lunch pct_min 
skills_or_excellence skills_priority excellence_priority skills_over_excellence [w=AFNLWGT];
eststo, title(Principals: `f');

};

estout * using "Final Tables\SASS_alldescriptives.txt",
cells(mean (fmt(1)))stats(N, fmt(0)) replace;


